export class StarIO10ErrorMessage {
    id;
    message;
    constructor(id, message) {
        this.id = id;
        this.message = message;
    }
    // 基本的・その他に分類されるエラー
    static UnknownError = new StarIO10ErrorMessage(0, "Unknown error.");
    static LoadLibraryFailed = new StarIO10ErrorMessage(1, "Load library failed.");
    static NotSupportedModel = new StarIO10ErrorMessage(2, "Not supported model.");
    static InvalidIdentifier = new StarIO10ErrorMessage(3, "Invalid identifier.");
    static AlreadyStarted = new StarIO10ErrorMessage(4, "Already started.");
    static SpecifiedArgumentValueIsOutOfSpecification = new StarIO10ErrorMessage(5, "Specified argument value is out of specification.");
    static Ios13IsUnsupported = new StarIO10ErrorMessage(6, "iOS 13 is unsupported.");
    static ArchitectureNotSupported = new StarIO10ErrorMessage(7, "Architecture not supported.");
    static InvalidTimeoutValue = new StarIO10ErrorMessage(8, "Specified timeout value is out of specification.");
    // プリンター通信・印刷機能関連のエラー
    static DeviceHasError = new StarIO10ErrorMessage(1000, "Device has error.");
    static PrinterIsHoldingPaper = new StarIO10ErrorMessage(1001, "Printer is holding paper.");
    static PrintTimedOut = new StarIO10ErrorMessage(1002, "Print timed out.");
    static DeviceNotFound = new StarIO10ErrorMessage(1003, "Device not found.");
    static DeviceNotFoundCallClose = new StarIO10ErrorMessage(1004, "Device not found. Connect the USB cable or turn on the device (if the StarPrinter instance has been opened, call the closeAsync method first), and try again.");
    static AlreadyOpened = new StarIO10ErrorMessage(1005, "Already Opened.");
    static OpenFailed = new StarIO10ErrorMessage(1006, "Open failed.");
    static TheDeviceIsInUseByAnotherProcess = new StarIO10ErrorMessage(1007, "The device is in use by another process.");
    static TheDeviceIsInUseByAnotherHost = new StarIO10ErrorMessage(1008, "The device is in use by another host.");
    static BadResponseFromDevice = new StarIO10ErrorMessage(1009, "Bad response from device.");
    static RequestTimedOut = new StarIO10ErrorMessage(1010, "Request timed out.");
    static NotOpened = new StarIO10ErrorMessage(1011, "Not opened.");
    static InitializeFailed = new StarIO10ErrorMessage(1012, "Initialize failed.");
    static WriteFailed = new StarIO10ErrorMessage(1013, "Write failed.");
    static ReadFailed = new StarIO10ErrorMessage(1014, "Read failed.");
    static CloseFailed = new StarIO10ErrorMessage(1015, "Close failed.");
    static DeviceIoControlFailed = new StarIO10ErrorMessage(1016, "Device IO Control failed.");
    static MethodNotAvailableDuringMonitoringPrinter = new StarIO10ErrorMessage(1017, "Method not available during monitoring printer.");
    // インターフェイス・検索機能関連のエラー
    static BluetoothUnavailable = new StarIO10ErrorMessage(2000, "Bluetooth unavailable.");
    static NetworkUnavailable = new StarIO10ErrorMessage(2001, "Network unavailable.");
    static UsbUnavailable = new StarIO10ErrorMessage(2002, "USB unavailable.");
    static InterfaceIsNotSpecified = new StarIO10ErrorMessage(2003, "Interface is not specified.");
    static NotSupportedInterface = new StarIO10ErrorMessage(2004, "Not supported interface.");
    static BluetoothLeDeviceIsNotPaired = new StarIO10ErrorMessage(2005, "Bluetooth LE device is not paired.");
    static WebWorkerUnavailable = new StarIO10ErrorMessage(2006, //StarIO10ErrorCodeは2003
    "Web Worker unavailable");
    // スプーラー機能関連のエラー
    static SpoolerIsDisabled = new StarIO10ErrorMessage(3000, "Spooler is disabled.");
    static SpoolerBufferIsNotEnough = new StarIO10ErrorMessage(3001, "Spooler buffer is not enough.");
    static JobIdNotExist = new StarIO10ErrorMessage(3002, "Specified JobID does not exist.");
    // 認証・パスワード関連のエラー
    static InvalidPassword = new StarIO10ErrorMessage(4000, "Invalid password.");
    static NeedToChangePassword = new StarIO10ErrorMessage(4001, "Need to change password.");
    // 一般的なデータフォーマット関連のエラー
    static JsonFormatError = new StarIO10ErrorMessage(5000, "JSON format error.");
    static InvalidSourceError = new StarIO10ErrorMessage(5001, "Invalid source.");
    // StarConfig関連のエラー
    static StarConfigFormatError = new StarIO10ErrorMessage(6000, "Star Configuration format error.");
    static StarConfigParameterError = new StarIO10ErrorMessage(6001, "Star Configuration parameter error.");
    static StarConfigSpecifiedFileError = new StarIO10ErrorMessage(6002, "Star Configuration specified file error.");
    // テンプレート印刷関連のエラー
    static TemplatePrintInvalidJsonFormat = new StarIO10ErrorMessage(7000, "Field data is Invalid JSON format.");
    static TemplatePrintInvalidNumberFormatSpecifier = new StarIO10ErrorMessage(7001, "Number format specifier is out of specification.");
    static TemplatePrintDifferentArrayReplacingSpecifier = new StarIO10ErrorMessage(7002, "There are replacing specifiers that indicate different array field data.");
    static TemplatePrintNonAsciiReplacingSpecifier = new StarIO10ErrorMessage(7003, "Replacing specifier contains Non-ASCII character.");
    // SMCSサーバーとの通信関連のエラー
    static CouldNotConnectToServer = new StarIO10ErrorMessage(8000, "Could not connect to the Star Micronics cloud server.");
    static ServerUrlError = new StarIO10ErrorMessage(8001, "The requested url may be incorrect.");
    static ServerRequestParameterError = new StarIO10ErrorMessage(8002, "The requested parameters may be incorrect.");
    static ServerAuthenticationError = new StarIO10ErrorMessage(8003, "Server authentication error.");
    static getUnexpectedErrorMessage() {
        const err = new Error();
        return `Unexpected state at ${err.stack}.`;
    }
}
